IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.Contrato_Fraccionar_Precio') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION dbo.Contrato_Fraccionar_Precio
END
GO

CREATE FUNCTION dbo.Contrato_Fraccionar_Precio(@pId_Contrato INT, @pPrecio DECIMAL(16,5), @pFecha DATETIME) 
RETURNS DECIMAL(16,5)
AS 

BEGIN

DECLARE @Retorno			DECIMAL(16,5)
DECLARE @Flag_Fracciona		CHAR(1)
DECLARE @Fecha_Hasta		DATETIME
DECLARE @Fin_Mes			DATETIME
DECLARE @Dia_Fin_Mes		SMALLINT
DECLARE @Semana				SMALLINT
DECLARE @Dia				SMALLINT


SET		@Retorno = @pPrecio


SELECT	@Flag_Fracciona = T.Flag_Fracciona 
		,@Fecha_Hasta = C.Fecha_Hasta
		FROM Contratos C, Contratos_Tipos T 
		WHERE C.Id_Tipo_Con = T.Id_Tipo_Con AND C.Id_Contrato = @pId_Contrato

IF UPPER(@Flag_Fracciona) IN ('D','S') AND DATEPART(mm,@pFecha) =  DATEPART(mm,@Fecha_Hasta) AND DATEPART(yy,@pFecha) = DATEPART(yy,@Fecha_Hasta)
BEGIN
    SET @Fin_Mes = dbo.CF_EOMONTH(@pFecha)
	SET @Dia_Fin_Mes = DATEPART(dd,@Fin_Mes)  --28,29,30,31

	SET @Dia = DATEPART(dd,@Fecha_Hasta)

	IF UPPER(@Flag_Fracciona) = 'S'
	BEGIN
		IF @Dia <= 7				SET @Semana = 1
		IF @Dia BETWEEN 8 AND 14	SET @Semana = 2
		IF @Dia BETWEEN 15 AND 21	SET @Semana = 3
		IF @Dia >= 22			    SET @Semana = 4
		SET @Retorno	= @Retorno / 4 * @Semana 
	END

	IF UPPER(@Flag_Fracciona) = 'D'
	BEGIN
		SET @Retorno	= @Retorno *  @Dia / @Dia_Fin_Mes
	END

END


					
RETURN ISNULL(@Retorno,0)
END
